﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Xml.Serialization;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.Storage;
using Windows.Storage.Pickers;
using Windows.Storage.Streams;
using Windows.UI.Popups;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.Graphics.Display;
using Windows.UI.ViewManagement;
using Callisto.Callisto_XamlTypeInfo;
using Callisto.Controls;
using Callisto.Controls.Common;
using Callisto.Effects;
using EAT_IT.Data;

// Die Elementvorlage "Standardseite" ist unter http://go.microsoft.com/fwlink/?LinkId=234237 dokumentiert.

namespace EAT_IT
{
    /// <summary>
    /// Eine Standardseite mit Eigenschaften, die die meisten Anwendungen aufweisen.
    /// </summary>
    public sealed partial class EigenesRezeptSpeichern : EAT_IT.Common.LayoutAwarePage
    {
        MyRecipe SpeicherRezept = new MyRecipe();
        List<string> ZutatenList;

        public EigenesRezeptSpeichern()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Füllt die Seite mit Inhalt auf, der bei der Navigation übergeben wird. Gespeicherte Zustände werden ebenfalls
        /// bereitgestellt, wenn eine Seite aus einer vorherigen Sitzung neu erstellt wird.
        /// </summary>
        /// <param name="navigationParameter">Der Parameterwert, der an
        /// <see cref="Frame.Navigate(Type, Object)"/> übergeben wurde, als diese Seite ursprünglich angefordert wurde.
        /// </param>
        /// <param name="pageState">Ein Wörterbuch des Zustands, der von dieser Seite während einer früheren Sitzung
        /// beibehalten wurde. Beim ersten Aufrufen einer Seite ist dieser Wert NULL.</param>
        protected override void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
        }

        /// <summary>
        /// Behält den dieser Seite zugeordneten Zustand bei, wenn die Anwendung angehalten oder
        /// die Seite im Navigationscache verworfen wird. Die Werte müssen den Serialisierungsanforderungen
        /// von <see cref="SuspensionManager.SessionState"/> entsprechen.
        /// </summary>
        /// <param name="pageState">Ein leeres Wörterbuch, das mit dem serialisierbaren Zustand aufgefüllt wird.</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
        }

        //Nachfolgend wird beim erstmaligen anklicken der entsprechenden Textboxen der vorherige Inhalt gelöscht (einmalig)
        private void AnwahlTitel(object sender, RoutedEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            tb.Text = string.Empty;
            tb.GotFocus -= AnwahlTitel;
        }

        private void AnwahlSchwierigkeit(object sender, RoutedEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            tb.Text = string.Empty;
            tb.GotFocus -= AnwahlSchwierigkeit;
        }

        private void AnwahlKurzbeschreibung(object sender, RoutedEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            tb.Text = string.Empty;
            tb.GotFocus -= AnwahlKurzbeschreibung;
        }

        private void AnwahlBeschreibung(object sender, RoutedEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            tb.Text = string.Empty;
            tb.GotFocus -= AnwahlBeschreibung;
        }

        private void AnwahlZutaten(object sender, RoutedEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            tb.Text = string.Empty;
            tb.GotFocus -= AnwahlZutaten;
        }

        //Hier kann ein Bild vom Computer geöffnet werden
        private async void BildOeffnen(object sender, RoutedEventArgs e)
        {
            FileOpenPicker openPicker = new FileOpenPicker();
            openPicker.ViewMode = PickerViewMode.Thumbnail;
            openPicker.SuggestedStartLocation = PickerLocationId.PicturesLibrary;
            openPicker.FileTypeFilter.Add(".jpg");
            openPicker.FileTypeFilter.Add(".jpeg");
            openPicker.FileTypeFilter.Add(".png");
            openPicker.FileTypeFilter.Add(".bmp");

            StorageFile file = await openPicker.PickSingleFileAsync();
            if (file != null)
            {
                SpeicherRezept.ImagePfad = file.Path.ToString();
            }
        }

        // Die Speichere Methode wird nach drücken des Speichern Buttons aufgerufen und speichert das Rezept mit den bisherigen Eingaben ab
        // Zuvor müssen noch die eingegebenen Zutaten in eine Liste umgewandelt werden. Nach dem speichern soll das Rezept
        // in den eigenen Rezepten angezeigt werden, deshalb wird SampleDataSource.NewSave genutzt. Abschließend erscheint ein Pop-up
        // das dem Nutzer anzeigt, dass korrekt gespeichert wurde und beim klicken des Ok-Buttons zur vorherigen Seite zurückführt.
        private async void Speichere(object sender, RoutedEventArgs e)
        {
            Random myrandom = new Random();
            int random = myrandom.Next(1, 10000000);
            string Dateiname =  random + ".EAT";
            StorageFile store = await ApplicationData.Current.LocalFolder.CreateFileAsync(Dateiname, Windows.Storage.CreationCollisionOption.ReplaceExisting);
            IRandomAccessStream sessionRandomAccess = await store.OpenAsync(FileAccessMode.ReadWrite);
            IOutputStream sessionOutputStream = sessionRandomAccess.GetOutputStreamAt(0);
            var serializer = new XmlSerializer(typeof(MyRecipe));

            string[] Filter={"\n"};
            ZutatenList=Zutaten.Text.Split(Filter, StringSplitOptions.RemoveEmptyEntries).ToList();

            SpeicherRezept.Zutaten = ZutatenList;
            SpeicherRezept.Titel = TitelBox.Text;
            SpeicherRezept.Zubereitung = Beschreibung.Text;
            SpeicherRezept.Kurzbeschreibung = Kurzbeschreibung.Text;
            SpeicherRezept.Schwierigkeit = "Schwierigkeit: " + Schwierigkeit.Text;
            SpeicherRezept.Dateiname = Dateiname;
            SpeicherRezept.Rating = Rate.Value;
            //Using DataContractSerializer , look at the cat-class
            //var sessionSerializer = new DataContractSerializer(typeof(List<object>), new Type[] { typeof(T) });
            //sessionSerializer.WriteObject(sessionOutputStream.AsStreamForWrite(), _data);

            //Using XmlSerializer , look at the Dog-class
            serializer.Serialize(sessionOutputStream.AsStreamForWrite(), SpeicherRezept);
            sessionRandomAccess.Dispose();
            await sessionOutputStream.FlushAsync();
            sessionOutputStream.Dispose();

            SampleDataSource.NewSave(SpeicherRezept);

            MessageDialog msgDialog = new MessageDialog("Gratuliere! Sie sind auf dem Weg zum Meisterkoch!", "Erfolgreich Gespeichert");

            //OK Button
            UICommand okBtn = new UICommand("OK");
            okBtn.Invoked = OkBtnClick;
            msgDialog.Commands.Add(okBtn);

            //Show message
            msgDialog.ShowAsync();
        }

        private void OkBtnClick(IUICommand command)
        {
            this.Frame.Navigate(typeof(SplitPage), "EigeneRezepte");
        }

    }
}

